--
SELECT TSystem.triggers__all__enable();
-- /*
DROP TABLE IF EXISTS twawi.abzu_p__rechnunge CASCADE;
DROP TABLE IF EXISTS TWawi.beleg_p__rechnunge CASCADE;
DROP TABLE IF EXISTS twawi.beleg_k__rechnunge CASCADE;
-- */

-- Kopf

--
CREATE TABLE twawi.beleg_k__rechnunge (
  kre_priorisieren              BOOLEAN NOT NULL DEFAULT FALSE,         -- Flag "Wichtig", bevorzugt behandeln gegenüber den anderen Belegen
          
  kx_valuta_datum               DATE,
  kx_buchdat                    DATE,                                   -- Übergabe Buchhaltung analog Ausgangsrechnung
  kx_buchmonth                  VARCHAR(6),                             -- Buchungszeitraum Format 'MMYYYY' Bsp: 022016 für Februar 2016 >>?? Anderes Format als Ausgangsrechnung??

  kre_zak_zahlung_freigabe      BOOL NOT NULL DEFAULT FALSE,            -- Freigabe (Zahlungslauf)
  kre_zahllauf_abschluss_datum  DATE,                                   -- beld_abschlussdatum --Zahlungslauf Abschlußdatum siehe Trigger beleg_k__rechnunge__b_50_u__zahlung
  
  kx_ad_krzl                    VARCHAR(30) NOT NULL REFERENCES adressen_keys ON UPDATE CASCADE, --Dokumentadresse, bspw. Lieferadresse im Einkauf 
  kx_ad_krzf                    VARCHAR(30) NOT NULL REFERENCES adressen_keys ON UPDATE CASCADE --Dokumentadresse, bspw. Rechnungsadresse im Einkauf oder Rechnungssteller bei Eingangsrechnung   
 ) INHERITS (twawi.beleg_k, TSystem_Wawi.beleg_x__allgfields, TSystem_Wawi.beleg_k__export_zoll, TSystem_Wawi.beleg_k__mahnung);
 
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_k__trigger__all__create('twawi','beleg_k__rechnunge');
 SELECT  TSystem_Wawi.beleg_k__constraints__all__create('twawi','beleg_k__rechnunge'); 

-- Trigger
 CREATE OR REPLACE FUNCTION twawi.beleg_k__rechnunge__b_500_u__zahlung() RETURNS TRIGGER AS $$
  BEGIN
   -- Falls Zahlungslauf/DTA benutzt wird 
   -- => Zahlart muss eingegeben sein, bevor Pruefer zugewiesen wird. Sonst kann Rechnung freigegeben werden und taucht im Zahlungslauf auf, obwohl noch ungeprueft 
   IF TSystem.Settings__GetBool('ER_Prodat_Zahlung') AND (new.k_zak_zahlart_za_id IS NULL)  AND (NOT new.k_pruef_db_usename1 IS NULL) THEN  
     RAISE EXCEPTION 'zahlart_za_id IS NULL  xtt10913';
   END IF;
   
   -- Wenn Beleg vollstaendig bezahlt / als abgeschlossen betrachtet, das Datum nachtragen
   IF (NOT old.k_zak_zahlung_erledigt) AND new.k_zak_zahlung_erledigt AND ( new.kre_zahllauf_abschluss_datum IS NULL )THEN
      new.kre_zahllauf_abschluss_datum := current_date;    
   END IF;    
   
   RETURN new;
  END $$ LANGUAGE plpgsql;
  --
  CREATE TRIGGER b_500_u__rechnunge__zahlung
   BEFORE UPDATE 
   ON twawi.beleg_k__rechnunge
   FOR EACH ROW
   EXECUTE PROCEDURE twawi.beleg_k__rechnunge__b_500_u__zahlung();
--
 
-- Position

--
CREATE TABLE TWawi.beleg_p__rechnunge (
  --
  px_menge_los                  NUMERIC(12,4),
  px_l_iso                      VARCHAR(5)  REFERENCES laender ON UPDATE CASCADE, -- Ursprungsland
  -- Verknüpfungen
  pre_einkauf_p_id              INTEGER REFERENCES ldsdok,              -- Bezug zur Vorgänger-Position im Einkauf
  pre_w_wen                     INTEGER REFERENCES wendat,              -- Bezug zur Vorgänger-Position im Wareneingang
  -- pre_ab_ix                     INTEGER REFERENCES abk,                 -- Bezug zu einer ABK --KILL????
  pre_a2_id                     INTEGER REFERENCES ab2,                 -- Bezug zu einem Arbeitsgang
    
  -- TODO
  belp_versandartbem            VARCHAR(100),
  belp_vorgaenger               INTEGER, --TODO REFERENCES belegpos ON UPDATE CASCADE ON DELETE SET NULL,               -- Position stammt aus dieser Vorgängerposition, falls aus Beleg übernommen. Sonst Vorgänger = w_wen, ld_id, ag_id etc ....
  belp_q_nr                     INTEGER REFERENCES qab,                 -- Bezug zu QAB (z.Bsp. bei Retourelieferschein)  
  belp_skontofaehig             BOOL NOT NULL DEFAULT TRUE,             -- Für Position kann Skonto berechnet werden
  belp_abzufaehig               BOOL NOT NULL DEFAULT TRUE              -- Position kann Ab- Zuschläge enthalten 
 ) INHERITS (twawi.beleg_p, TSystem_Wawi.beleg_p__extend__wawi__adk);
 
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p__rechnunge', 'twawi','beleg_k__rechnunge');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p__rechnunge'); 
 
 
-- Trigger
 -- Bei Erstellen oder Aktualisierung einer Auswärtsrechnung, aktualisieren wir den Rueckmelde-Eintrag
 CREATE OR REPLACE FUNCTION twawi.beleg_p__rechnunge__a_500_iu__update_rm() RETURNS TRIGGER AS $$
  DECLARE awap VARCHAR; --Auswärtsarbeitspaket
  BEGIN    
    -- Auswärts-AP des Arbeitsganges holen
    SELECT a2_aknr INTO awap FROM ab2 WHERE a2_id = new.pre_a2_id AND a2_ausw; 
    -- Entspricht nicht dem Arbeitspaket aus ABK. Oder hat kein Auswärtspaket? Evtl. Speditionsrechnung oder sowas? Ignorieren wir auf jeden Fall.
    IF (awap IS NULL) OR (new.p_aknr IS DISTINCT FROM awap) THEN
      RETURN new;
    END IF;
    --  
    PERFORM tplanterm.update_rm_ausw(new.pre_a2_id, new.pre_w_wen, new.p_id); 
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;
  --   
  CREATE TRIGGER a_500_iu__rechnunge__update_rm
   AFTER INSERT OR UPDATE
   OF pre_a2_id, pre_w_wen
      , p_menge
      , p_preis, p_preis_in_pe, p_preis_me, p_preis_pe
      , p_rabatt, p_rabatt_gesamt, p_rabatt_able      
      , p_erfasst_datum
   ON twawi.beleg_p__rechnunge
   FOR EACH ROW  -- Nur wenn Rechnung ohne Wareneingang. Bei Auswaerts-Ruecklieferung macht das der Wendat Trigger.
   WHEN ((new.pre_a2_id IS NOT NULL) AND (new.pre_w_wen IS NULL))
   EXECUTE PROCEDURE twawi.beleg_p__rechnunge__a_500_iu__update_rm();
-- TODO: Keywordsearch
 
--
 
-- Abzuschläge

--
CREATE TABLE twawi.abzu_p__rechnunge  -- TODO Feldklärung
 (
       belxaz_belegtyp         VARCHAR(3),   -- KILL  NOT NULL DEFAULT 'ERG' REFERENCES belegtyp,  
       belxaz_vorgaenger       INTEGER,      -- KILL  REFERENCES belegabzu  ON UPDATE CASCADE,
       belaz_ks_abt           VARCHAR(9),   -- KILL? TODO In alter Struktur nur im Kopf, nichtmal in Position!
   belpaz_canrabatt       BOOLEAN NOT NULL DEFAULT FALSE  -- TODO in Basis und Berechnungsfunktionen!        
 ) INHERITS (TWawi.abzu_p);
-- Constraints und Trigger
 SELECT TSystem_Wawi.abzu_p__constraints__all__create('twawi.abzu_p__rechnunge', 'twawi.beleg_k__rechnunge', 'twawi.beleg_p__rechnunge');
 SELECT TSystem_Wawi.abzu_p__trigger__all__create('twawi','abzu_p__rechnunge', 'twawi','beleg_p__rechnunge'); 
-- Trigger
 --
/* TODO 
-- Schlüssel für Standardsuche Eingangsrechnungen Keywordsearch (Kopf), #7157
 CREATE OR REPLACE FUNCTION eingrechdokument__a_iu_keywordsearch() RETURNS TRIGGER AS $$
  BEGIN
    PERFORM TSystem.kws_create_keywords(new.*);
    RETURN new;
  END $$ LANGUAGE plpgsql;
  
  CREATE TRIGGER eingrechdokument__a_iu_keywordsearch
    AFTER INSERT OR UPDATE
    OF beld_dokunr, beld_refbeleg, beld_vertragsnummer
    ON eingrechdokument
    FOR EACH ROW
    EXECUTE PROCEDURE eingrechdokument__a_iu_keywordsearch();
*/
--
    
-- Views

/* -- TODO update

 CREATE OR REPLACE FUNCTION TSystem.views__rechnunge__recreate() RETURNS VOID AS $$
  BEGIN
    CREATE OR REPLACE VIEW z_99_deprecated.eingrechdokument AS (
     SELECT
       k_id_oldstructure,
       'ERG'::VARCHAR               AS beld_belegtyp,
       --Grundfelder,
       k_id                         AS beld_id,                                        
       k_nummer                     AS beld_dokunr,                   
       k_kba_key                    AS beld_belegart,                 
       k_titel                      AS beld_titel,                    
       k_txt_anschr                 AS beld_kopftext,                 
       k_txt_anschr_rtf             AS beld_kopftext_rtf,             
       k_txt_schluss                AS beld_fusstext,                 
       k_txt_schluss_rtf            AS beld_fusstext_rtf,             
       x_allgv1                     AS beld_allg1,                    
       x_allgv2                     AS beld_allg2,                    
                                    
       k_ad_krz                     AS beld_krzbesteller,             
       kx_ad_krzl                   AS beld_krzlieferung,             
       kx_ad_krzf                   AS beld_krzrechnung,              
       k_apext_ap_krzl              AS beld_apkrzl,                   
       k_apext                      AS beld_ap,                       
       k_apint_db_usename1          AS beld_apint,                    
                                          
       --Statusinformationen,              
       k_definitiv                  AS beld_definitiv,                
       k_pruef_db_usename1          AS beld_pruefer,          -- Mitarbeiternummer des zuständigen Mitarbeiters für Pruefung der Rechnung auf inhaltliche Korrektheit
       k_pruef_db_usename1_real     AS beld_geprueftvon,      -- Mitarbeiternummer von dem, der tatsächlich geprüft hat(kann ja auch Vertreter gewesen sein)
       k_pruef_freigabe1            AS beld_geprueft,         -- Beleg wurde freigegeben (beachte auch "kre_zak_zahlung_freigabe     AS beld_freigabe")
       k_pruef_freigabe_datum1      AS beld_pruefdatum,       -- An dem Datum erfolgte die Prüfung.
                                             
       k_print                      AS beld_print,                    
       -- beld_bindefrist,                    
       k_erfasst_datum              AS beld_erstelldatum,             
       -- beld_bestaetigung_bis,             
       -- beld_exportdatum,         kx_buchdat?
       kre_priorisieren             AS beld_priorisieren,                 
       kx_buchmonth                 AS beld_buchmonth,                              
       --,                            
                                     
       -- Zahlungsrelevante, Felder   
       -- beld_fixwert,                  
       k_zak_zahlziel_d             AS beld_zak,                      
       k_zak_skonto_verf_d          AS beld_skv,                      
       k_zak_skonto_proz            AS beld_sks,                      
       k_zak_bem                    AS beld_zakbem,  
                                    
       k_versand_v_id               AS beld_versandart,
       k_versand_bem                AS beld_versandartbem,
       k_versand_ort_adkrz          AS beld_versandort,   
                                    
       k_wert_tot_netto             AS beld_netto,                    
       k_wert_tot_brutto            AS beld_brutto,                   
       k_wert_tot_netto_gwaer       AS beld_netto_basis_w,            
       k_wert_tot_brutto_gwaer      AS beld_brutto_basis_w,           
       -- beld_steuer,              --steuersumme           
       -- beld_skonto,              --skontosumme           
       NULL::NUMERIC                AS beld_bezahlt,  --Betrag --TODO #13025   Funktino für Betrag bereits gezahlt            
       k_rabatt_gesamt              AS beld_gesamtrabatt,             
       kx_valuta_datum              AS beld_valutadatum,              
       k_waer                       AS beld_waehr,                    
       k_zak_zahlart_za_id          AS beld_zahlart,                  
       -- beld_gewicht,                      
                                        
       --, Versandinformationen           
                                    
       -- beld_zahl_skontiert       BOOL DEFAULT FALSE,                     -- Wenn die Rechnung bezahlt wurde, haben wir dann Skonto bekommen?  
       k_mahn_stufe                 AS beld_mahnstufe,
       k_mahn_erfasst_datum         AS beld_mahndatum,
       
       kre_zak_zahlung_freigabe     AS beld_freigabe,                       -- Zur Zahlung freigegeben
       k_zak_zahlung_erledigt       AS beld_verbucht,                       -- Bezahlt
       kre_zahllauf_abschluss_datum AS beld_abschlussdatum,
                                    
       kx_refbeleg		            AS beld_refbeleg,
       
       -- beld_vertragsnummer   VARCHAR(50),                 
       --, System                     
       dbrid,                         
       insert_date,                   
       insert_by,                     
       modified_by,                   
       modified_date                 
     FROM
       twawi.beleg_k__rechnunge
     );
    CREATE OR REPLACE VIEW z_99_deprecated.eingrech AS SELECT * FROM z_99_deprecated.eingrechdokument; 
    --
    CREATE OR REPLACE VIEW z_99_deprecated.eingrech_pos AS ( -- alte belegpos mit belp_belegtyp = 'ERG'
     SELECT
       'ERG':: VARCHAR           AS belp_belegtyp,
     
       p_id_oldstructure,
       -- Grundfelder 
       p_id                      AS belp_id,
       p_pos                     AS belp_pos,  
       p_parent_pos              AS belp_hauptpos,
       p_k_id                    AS belp_dokument_id,
       --                           
       p_ad_krz                  AS belp_krzbesteller,
       p_ad_krzf                 AS belp_krzrechnung,
       p_ad_krzl                 AS belp_krzlieferung,
       --  
       px_an_nr                  AS belp_projektnummer,
       p_txt_int                 AS belp_txt,  
       p_txt_int_rtf             AS belp_txt_rtf,
       p_txt                     AS belp_dokutxt,
       p_txt_rtf                 AS belp_dokutxt_rtf,
       p_adress_referenz_nummer  AS belp_referenz,
       -- Warenbezug
       p_aknr                    AS belp_aknr,
       p_ak_bez                  AS belp_akbez,
       p_aknr_referenz           AS belp_referenzaknr,
       p_menge                   AS belp_menge,
       p_menge_gme               AS belp_menge_gme,
       -- p_mengef_gme AS belp_menge_done --Lieferschein
       -- belp_menge_done_gme
       p_me                      AS belp_mce,
       px_menge_los              AS belp_los,
       px_l_iso                  AS belp_l_iso,
       -- belp_gewicht
       -- p_nbedarf AS belp_bestandsaktiv --aktuell nie in verwendung
       -- belp_versandart
       belp_versandartbem,
     
       p_erfasst_datum           AS belp_erstelldatum,
       p_done                    AS belp_erledigt,
       p_storno                  AS belp_storniert, 
     
       -- Zahlungsinformationen
       
       p_rabatt_able             AS belp_rabattfaehig,
       
       p_konto_aufwand           AS belp_konto,
       p_ks                      AS belp_kostenstelle,
       p_waer_kurs               AS belp_kurs,
       p_waer                    AS belp_waehr,
       p_steu_code               AS belp_steucode,
     
       -- Preisberechnung
       p_steu_proz               AS belp_steuproz,
       p_preis_in_pe             AS belp_preis,
       p_preis_gwaer             AS belp_preis_basis_w,
       p_preis_gme               AS belp_preis_gme,
       p_preis_gme_gwaer         AS belp_preis_gme_basis_w,
       -- TODO IfThen ( (p_menge_gme = 0), 0, p_wert_netto_gwaer / do1If0(p_menge_gme)) + ( COALESCE( belp_sumBelegAbzu,0) * p_waer_kurs ) / do1If0(p_menge_gme)
       0                         AS belp_abzupreis_gme,
       p_preis_pe                AS belp_preiseinheit,
       p_wert_tot_netto          AS belp_netto,
       p_wert_tot_brutto         AS belp_brutto,
       p_wert_netto_gwaer        AS belp_netto_basis_w,
       p_wert_brutto_gwaer       AS belp_brutto_basis_w,
       p_rabatt                  AS belp_rabatt,
       p_wert_abzu_brutto        AS belp_sumabzu,
       -- belp_sumBelegAbzu  belp_sumBelegAbzu             NUMERIC NOT NULL DEFAULT 0,             -- Anteil der Position an Belegabzuschlaegen (Anteiliger Beleg-NettoUmsatz) in Belegwaehrung.
       p_preis_me                AS belp_preis_mce,
    
       p_bstat1                  AS belp_bstat,
       p_bstat2                  AS belp_bstat1,
       p_bstat3                  AS belp_bstat2,
       
       -- Verknüpfungen
       pre_einkauf_p_id          AS belp_ld_id,
       pre_a2_id		         AS	belp_a2_id,
       pre_w_wen                 AS belp_w_wen,
    
       belp_vorgaenger,
       -- belp_ab_ix,
       belp_q_nr,   
       belp_skontofaehig,
       belp_abzufaehig,
         
       --System
       dbrid,
       insert_date,
       insert_by,
       modified_by,
       modified_date  
     FROM
     twawi.beleg_p__rechnunge
     ); 
    --
    CREATE OR REPLACE VIEW z_99_deprecated.belegabzu AS ( --Konvertierung altes Kopfbezogen
     SELECT
      az_id_oldstructure,
      az_id                   AS belaz_id,
      az_k_id                 AS belaz_dokument_id,
      az_type                 AS belaz_type,
      az_visible              AS belaz_visible,
      
      az_pos                  AS belaz_pos, 
      az_abz_id               AS belaz_abzu_id,
      az_anzahl               AS belaz_anzahl,
      az_preis                AS belaz_betrag,
      az_preis_prozentual     AS belaz_prozent,
      
      az_steu_code            AS belaz_steucode,
      az_steu_proz            AS belaz_steuproz,
      
      az_canskonto            AS belaz_canskonto,
      belaz_ks_abt,
      az_konto                AS belaz_konto,
     
      az_txt                  AS belaz_zutxt,
      az_txt_rtf              AS belaz_zutxt_rtf,
      az_txt_int              AS belaz_zutxt_int,
     
      az_source_table         AS belaz_source_table,
      az_source_dbrid         AS belaz_source_dbrid,
    
      belxaz_belegtyp         AS belaz_belegtyp,
      belpaz_canrabatt        AS belaz_canrabatt,
      belxaz_vorgaenger       AS belaz_vorgaenger,  
      --
      dbrid,
      insert_date,
      insert_by,
      modified_date,
      modified_by
      
     FROM
      twawi.abzu_p__rechnunge
     );
    --
    CREATE OR REPLACE VIEW z_99_deprecated.belegposabzu AS ( --Konvertierung altes Positionsbezogen
     SELECT
      az_id_oldstructure,
      az_id                   AS belpaz_id,
      az_k_id,
      az_p_id                 AS belpaz_belegpos_id,
      az_type                 AS belpaz_type,
      az_visible              AS belpaz_sichtbar,
      
      az_pos                  AS belpaz_pos, 
      az_abz_id               AS belpaz_abzu_id,
      az_anzahl               AS belpaz_anzahl,
      az_preis                AS belpaz_betrag,
      az_preis_prozentual     AS belpaz_prozent,
      
      az_steu_code            AS belpaz_steucode,
      az_steu_proz            AS belpaz_steuproz,
      
      az_canskonto            AS belpaz_canskonto,
      -- az_ks                   AS belpaz_ks_abt,
      az_konto                AS belpaz_konto,
     
      az_txt                  AS belpaz_zutxt,
      az_txt_rtf              AS belpaz_zutxt_rtf,
      az_txt_int              AS belpaz_zutxt_int,
      
      az_source_table         AS belpaz_source_table,
      az_source_dbrid         AS belpaz_source_dbrid,
      
      belxaz_belegtyp         AS belpaz_belegtyp,
      belpaz_canrabatt,
      belxaz_vorgaenger       AS belpaz_vorgaenger,
      
      --
      dbrid,
      insert_date,
      insert_by,
      modified_date,
      modified_by
       
     FROM
      twawi.abzu_p__rechnunge
     );
    
    --
    -- Zusammengesetzter kack wegen kompatibilität alte Funktionen
    
    --
    CREATE OR REPLACE VIEW z_99_deprecated.belegpos AS  
      -- TODO klären ob wirklich, oder Funktion anpassen (zB SQL-Funktion vorgänger_bez, VIEW treporting.allg_beleg_positionen, treporting.recnokeyword__print_setting__copy)
     SELECT
      dbrid, --recnokeyword__print_setting__copy
      belp_id,
      belp_aknr, --allg_beleg_positionen
      belp_mce, --
      belp_vorgaenger,
      belp_ld_id,
      NULL::INTEGER AS belp_ag_id,
      belp_w_wen,
      NULL::INTEGER AS belp_l_nr,
      belp_q_nr,
      belp_belegtyp,
      NULL::INTEGER AS belp_ab_ix,
      belp_a2_id
     FROM 
      z_99_deprecated.eingrech_pos
     UNION
     SELECT
      dbrid,
      belp_id,
      belp_aknr,
      belp_mce,
      belp_vorgaenger,
      NULL::INTEGER AS belp_ld_id,
      belp_ag_id,
      NULL::INTEGER AS belp_w_wen,
      belp_l_nr,
      belp_q_nr,
      belp_belegtyp,
      belp_ab_ix,
      belp_a2_id
     FROM 
      z_99_deprecated.lieferschein_pos
     ;
    
  END $$ LANGUAGE plpgsql;

  
 -- 
 -- TODO SELECT TSystem.views__Twawi_abzu__recreate();
 
 CREATE OR REPLACE FUNCTION TSystem.views__beleg__recreate() RETURNS VOID AS $$ -- Todo auftrennen : eingrech
  BEGIN
      
    PERFORM  TSystem.views__lieferscheinv__recreate();
    PERFORM  TSystem.views__rechnunge__recreate();
    
  END $$ LANGUAGE plpgsql; 

 SELECT TSystem.views__beleg__drop();
 SELECT TSystem.views__beleg__recreate();

-- */
  
